/*
 * fc_usb_tcu_PRC_JSONParser.h
 *
 *  Created on: Apr 20, 2015
 *      Author: kl81hc
 */

#ifndef FC_USB_TCU_PRC_JSONPARSER_H_
#define FC_USB_TCU_PRC_JSONPARSER_H_

#include "I_fc_usb_tcu_JSONParser.h"

#include <fstream>
#define CertificateFilePath "/var/opt/bosch/dynamic/ffs/tcu/CertificateFile.crt"

class fc_usb_tcu_PRC_JSONParser : public I_fc_usb_tcu_JSONParser
{

public:
	fc_usb_tcu_PRC_JSONParser(fc_usb_tcu_tclAppMain* poMainAppl);
	~fc_usb_tcu_PRC_JSONParser();

	std::ofstream CertificateFile;

	tBool vParseChannelDataJSON(Json::Value& root, T_tcu_channel_data_result& oChannelData);
	tBool vParseChannelMasterDataJSON(Json::Value& root, T_tcu_channel_master_data_result& oChannelMasterData);
	tBool bParseFavoriteChannelList(Json::Value& root, T_tcu_Favorite_Channel_List& oFavoriteChannelDataList);
	tBool bParseAuthenticationResultData(Json::Value jAuthenticationResultData, T_tcu_AuthenticationResultData& oAuthenticationResultData);
	
	
	tBool vParseChargingStationsData(tU32& u32ClientToken, Json::Value& root, T_tcu_response_charging_stations_list_result& oChargingStationsData);
	tBool vParseChargingSpotData(Json::Value & ChargingSpotData, T_tcu_charging_spot& oChargingSpotData);
	tBool vParseVacantStationsData(tU32& u32ClientToken, Json::Value& root, T_tcu_response_vacancy_stations_list_result& oVacantStationsData);

	//@rav1hc: this function only for JPN
	tBool vParseChargingSpotDataforJPN(tU32& u32ClientToken, Json::Value & ChargingSpotDataJPN, T_tcu_charging_spot_data_JPN& oChargingSpotDataJPN);
	tBool vParseVacancySpotDataforJPN(tU32& u32ClientToken, Json::Value & VacancySpotDataJPN, T_tcu_vacancy_spot_data_JPN& oVacancySpotDataJPN);
	virtual const tChar* getName() const { return "fc_usb_tcu_PRC_JSONParser"; };
	virtual tVoid vHandleMessage(fc_usb_tcu_tclBaseIf::TMsg* pMsg){(void)pMsg;}
	virtual tVoid vHandleTraceMessage(const tUChar* puchData){(void)puchData;}
	virtual tVoid vGetReferences(){;}
	virtual tVoid vStartCommunication(){;}
	virtual tVoid vTraceInfo(){;}
private:
	/******************************************** PARSE CHANNEL DATA *************************************************************************/
	tBool parseChannelDataInformationHeaderPart(Json::Value & jChannelDataInformationHeaderPart, T_tcu_channel_data_information_header & oDest);
	tBool parseChannelDataInformationRecordPart(Json::Value & jChannelDataInformationRecordPart, T_tcu_channel_data_information & oDest);
	tBool parseChannelDataInformationRecordItem(Json::Value & jChannelDataInformationRecordPart, T_tcu_channel_data_information_record & oDest);
	tBool parseLocation(Json::Value & jChannelDataInformationRecordPart, T_tcu_Location& oLocation);
	tBool parseExecutionInformation(Json::Value & jChannelDataInformationRecordPart,T_tcu_Exection_Information& oExecutionInformation);
	tBool parseRouteCalc(Json::Value jRouteCalc, T_tcu_Route_Calc& oRouteCalc);
	tBool parseCall(Json::Value jCall, T_tcu_Call& oCall);
	tBool parseAutoPlay(Json::Value jAutoPlay, T_tcu_Auto_Play& oAutoPlay);
	tBool parseAutoDJExec(Json::Value jAutoDJExec, T_tcu_AutoDJ_Exec& oAutoDJExec);
	tBool parseOperatorCall(Json::Value jOperatorCall, T_tcu_Operator_Call& oOperatorCall);
	tBool parseDispList(Json::Value jDispList, T_tcu_Disp_List& oDispList);
	tBool parseAutoPlayWithMappoint(Json::Value jAutoPlayWithMappoint, T_tcu_AutoPlay_with_Mappoint& oAutoPlayWithMappoint);
	/******************************************** PARSE CHANNEL MASTER DATA *************************************************************************/

	tBool parseChannelMasterDataFileHeader(Json::Value & jCMD, T_tcu_channel_master_data_result & oChannelMasterData);
	tBool parseChannelMasterDataHeader(Json::Value & jCMD, T_tcu_channel_master_data_result & oChannelMasterData);
	tBool parseFolderDefinitionInformation(Json::Value & jCMD, T_tcu_channel_master_data_result & oChannelMasterData);
	tBool parseChannelDefinitionInformation(Json::Value & jCMD, T_tcu_channel_master_data_result & oChannelMasterData);
	/******************************************** PARSE CHARGE STATION DATA *************************************************************************/
	tBool parseChargingStationsDataHeader(Json::Value & jCSD, T_tcu_response_charging_stations_list_result & oChargingStationsData);
	tBool parseChargingStationsDataInformation(Json::Value& jPOIIDData, T_tcu_charging_stations_response_datarecord& oPOIIDInfo);
	tBool parseLocationCoordinate(Json::Value & jLocation, T_tcu_Location& oLocation);	
	/******************************************** PARSE CHARGING SPOT DATA **************************************************************************/			
	tBool parseLocationForChargingSpotData(Json::Value & ChargingSpotData, T_tcu_Location& oLocation);

	//@rav1hc: only for JPN
	tBool parseEntranceinformationList(Json::Value & jChargingSpotDataJPN, std::vector<T_tcu_Entranceinformation>& oEntranceinformationList);
	tBool parseEntranceinformationItem(Json::Value & JEntranceinformation, T_tcu_Entranceinformation& oEntranceinformation);

	tBool parsePartnersfacilityinformationList(Json::Value & jChargingSpotDataJPN, std::vector<T_tcu_Partnersfacilityinformation>& oPartnersfacilityinformationList);
	tBool parsePartnersfacilityinformationItem(Json::Value & jPartnersfacility , T_tcu_Partnersfacilityinformation& oPartnersfacilityinformation);

	tBool parseInstallationfacilityinformationList(Json::Value & jChargingSpotDataJPN, std::vector<T_tcu_Installationfacilityinformation>& oInstallationfacilityList);
	tBool parseInstallationfacilityinformationItem(Json::Value & jInstallationfacility , T_tcu_Installationfacilityinformation& oInstallationfacility);

	tBool parseChargingtypeList(Json::Value & jChargingSpotDataJPN, std::vector<T_tcu_Chargingtype>& oChargingtypeList);
	tBool parseChargingtypeItem(Json::Value & jChargingtype , T_tcu_Chargingtype& oChargingtype);

	tBool parseChargingInfomationList(Json::Value & jChargingSpotDataJPN, std::vector<T_tcu_ChargingInfomation>& oChargingInfomationList);
	tBool parseChargingInfomationItem(Json::Value & jChargingInfomation , T_tcu_ChargingInfomation& oChargingInfomation);

	tBool parseVacancyChargingInfomationList(Json::Value & jVacancySpotDataJPN, std::vector<T_tcu_ChargingInfomation>& oChargingInfomationList);
	tBool parseVacancyChargingInfomationItem(Json::Value & jChargingInfomation , T_tcu_ChargingInfomation& oChargingInfomation);

	tBool parseInformationProvisionTime(Json::Value & root, T_tcu_infomation_provision_time& oInformationProvisionTime);


	/******************************************** PARSE VACANT STATIONS DATA *************************************************************************/
	tBool parseVacantStationsDataHeader(Json::Value & jVSD, T_tcu_response_vacancy_stations_list_result & oVacantStationsData);
	tBool parseVacantStationsDataInformation(Json::Value& jPOIIDData, T_tcu_vacancy_station_response_datarecord& oPOIIDInfo);
	tBool vParseVICSData(Json::Value & VICSData, T_tcu_VICS_Response_Data& oVICSData) 	;
	/******************************************** PARSE DOWNLOAD PART AUTHENTICATION DATA RESPONSE *************************************************************************/
	tBool bParsePartAuthResponseJSON(Json::Value & response, T_tcu_PartAuthentication_Response_Data& tPartAuth);
	/******************************************** PARSE USER AUTHENTICATION RESPONSE DATA *************************************************************************/
	tBool bParseUserAuthResponseJSON(Json::Value & response, T_tcu_UserAuthToken_Response_Data& tUserAuth);
	tBool bGetTokenArray(Json::Value& root_in, Json::Value& root_out);
	tBool bParseDecodedIdToken(Json::Value & root_in, std::string& root_out);

};

#endif /* FC_USB_TCU_PRC_JSONPARSER_H_ */
